/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class Decoder {
    private DataInputStream inputStream;
    private ScreenBuffer[] buffers;
    private ChunkHeader[] chunkHeaders = new ChunkHeader[4000];
    private ScreenBuffer[] chunks = new ScreenBuffer[4000];

    public static final short changeShortEndian(short s) {
        return (short)((s & 0xFF) << 8 | (s & 0xFF00) >> 8);
    }

    public static final int changeIntEndian(int n) {
        return (n & 0xFF) << 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >> 8 | (n & 0xFF000000) >>> 24;
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Decoder(String string, int n) {
        try {
            Object object;
            if (n == 0) {
                object = new FileInputStream(string);
                this.inputStream = new DataInputStream(new GZIPInputStream((InputStream)object));
            }
            if (n == 1) {
                object = new URL(string);
                URLConnection uRLConnection = null;
                uRLConnection = ((URL)object).openConnection();
                uRLConnection.connect();
                this.inputStream = new DataInputStream(new GZIPInputStream(new BufferedInputStream(uRLConnection.getInputStream(), 4096)));
            }
        }
        catch (IOException iOException) {
            System.out.println("Can't open file stream");
            this.inputStream = null;
            return;
        }
        System.out.println("MarkSupported:" + this.inputStream.markSupported());
        this.inputStream.mark(2000000000);
        this.buffers = new ScreenBuffer[256];
        for (int i = 0; i < 256; ++i) {
            this.buffers[i] = new ScreenBuffer(80, 50, 32, 7);
        }
    }

    public Frame nextFrame() {
        int n;
        int n2;
        int n3;
        int n4;
        byte by;
        byte by2;
        int n5;
        if (this.inputStream == null) {
            return null;
        }
        try {
            n5 = Decoder.changeIntEndian(this.inputStream.readInt());
            by2 = this.inputStream.readByte();
            by = this.inputStream.readByte();
            n4 = this.inputStream.readByte();
            n3 = this.inputStream.readByte();
            n2 = Decoder.changeShortEndian(this.inputStream.readShort());
            for (n = 0; n < n2; ++n) {
                this.chunkHeaders[n] = new ChunkHeader(Decoder.changeShortEndian(this.inputStream.readShort()), Decoder.changeShortEndian(this.inputStream.readShort()));
            }
            for (n = 0; n < n2; ++n) {
                this.chunks[n] = new ScreenBuffer(4000, 1);
                for (int i = 0; i < this.chunkHeaders[n].len; ++i) {
                    this.chunks[n].buffer[i][0] = this.inputStream.readByte();
                    this.chunks[n].buffer[i][1] = this.inputStream.readByte();
                }
            }
        }
        catch (IOException iOException) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.inputStream = null;
            return null;
        }
        if (n4 < 0) {
            n4 += 256;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        this.buffers[n3].copyFrom(this.buffers[n4], 0, 0, 4000);
        for (n = 0; n < n2; ++n) {
            this.buffers[n3].copyFrom(this.chunks[n], 0, this.chunkHeaders[n].pos, this.chunkHeaders[n].len);
        }
        return new Frame(this.buffers[n3], by2, by, n5 + 3500 - 3500);
    }

    private class ChunkHeader {
        public short pos;
        public short len;

        ChunkHeader(short s, short s2) {
            this.pos = s;
            this.len = s2;
        }
    }
}

