import java.awt.*;

public class DOSFont {
	public static final int fontWidth = 8, fontHeight = 16;

	private static final int[][] DOSColors = { // b,g,r
			{ 0x00, 0x00, 0x00 },// black
			{ 0xaa, 0x00, 0x00 },// blue
			{ 0x00, 0xaa, 0x00 },// green
			{ 0xaa, 0xaa, 0x00 },// cyan
			{ 0x00, 0x00, 0xaa },// red
			{ 0xaa, 0x00, 0xaa },// magenta
			{ 0x00, 0x55, 0xaa },// brown
			{ 0xaa, 0xaa, 0xaa },// light gray
			{ 0x55, 0x55, 0x55 },// dark gray
			{ 0xff, 0x55, 0x55 },// light blue
			{ 0x55, 0xff, 0x5f },// light green
			{ 0xff, 0xff, 0x55 },// light cyan
			{ 0x55, 0x55, 0xff },// light red
			{ 0xff, 0x55, 0xff },// light magenta
			{ 0x55, 0xff, 0xff },// yellow
			{ 0xff, 0xff, 0xff } // white
	};

	// private Component comp;

	public DOSFont() {
	}

	public static void drawbmShort(Graphics g, short c, int x, int y) {
		if (c < 0)
			c += 256;
		for (int i = 0; i < 16; i++) {
			int b = FontData.font[c][i];
			if (b < 0)
				b += 256;
			for (int j = 7; (j >= 0) & (b != 0); j--) {
				if (b % 2 == 1)
					g.fillRect(x + j, y + i, 1, 1);
				b >>= 1;
			}
		}
	}

	public static void drawbmChar(Graphics g, char c, int x, int y) {
		drawbmShort(g, (short) c, x, y);
	}

	public static void drawbmAttrShort(Graphics g, short c, byte attr, int x, int y) {
		Color bg, fg;
		byte bc, fc;
		fc = (byte) (attr & (0x0f));
		bc = (byte) ((attr & (0xf0)) >>> 4);

		bg = new Color(DOSColors[bc][2], DOSColors[bc][1], DOSColors[bc][0]);
		fg = new Color(DOSColors[fc][2], DOSColors[fc][1], DOSColors[fc][0]);

		g.setColor(bg);
		g.fillRect(x, y, 8, 16);

		if (fc == bc)
			return;
		g.setColor(fg);
		drawbmShort(g, c, x, y);
	}

	public static void drawbmAttrAccShort(Graphics g, short c, byte attr, int x, int y) {
		drawbmAttrShort(g, c, attr, x, y);
		return;
	}

	public static void drawbmAttrChar(Graphics g, char c, byte attr, int x, int y) {
		drawbmAttrShort(g, (short) c, attr, x, y);
	}

	public static void drawbmString(Graphics g, String s, int x, int y) {
		int i;
		for (i = 0; i < s.length(); i++)
			drawbmChar(g, s.charAt(i), x + i * 8, y);
	}

	public static void drawCursor(Graphics g, byte attr, int x, int y) 
	{
		byte fc = (byte) (attr & (0x0f));

		Color fg = new Color(DOSColors[fc][2], DOSColors[fc][1], DOSColors[fc][0]);
		g.setColor(fg);
		g.fillRect(x, y+14, 8, 2);
	}

	/** *********************************************************************** */

	public static class FontData {
		public static final byte[][] font = {
				{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 126, -127, -91, -127, -127, -67, -103, -127, -127, 126,
						0, 0, 0, 0 },
				{ 0, 0, 126, -1, -37, -1, -1, -61, -25, -1, -1, 126, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 108, -2, -2, -2, -2, 124, 56, 16, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 16, 56, 124, -2, 124, 56, 16, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 24, 60, 60, -25, -25, -25, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 0, 0, 24, 60, 126, -1, -1, 126, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 24, 60, 60, 24, 0, 0, 0, 0, 0, 0 },
				{ -1, -1, -1, -1, -1, -1, -25, -61, -61, -25, -1, -1, -1, -1,
						-1, -1 },
				{ 0, 0, 0, 0, 0, 60, 102, 66, 66, 102, 60, 0, 0, 0, 0, 0 },
				{ -1, -1, -1, -1, -1, -61, -103, -67, -67, -103, -61, -1, -1,
						-1, -1, -1 },
				{ 0, 0, 30, 14, 26, 50, 120, -52, -52, -52, -52, 120, 0, 0, 0,
						0 },
				{ 0, 0, 60, 102, 102, 102, 102, 60, 24, 126, 24, 24, 0, 0, 0, 0 },
				{ 0, 0, 63, 51, 63, 48, 48, 48, 48, 112, -16, -32, 0, 0, 0, 0 },
				{ 0, 0, 127, 99, 127, 99, 99, 99, 99, 103, -25, -26, -64, 0, 0,
						0 },
				{ 0, 0, 0, 24, 24, -37, 60, -25, 60, -37, 24, 24, 0, 0, 0, 0 },
				{ 0, -128, -64, -32, -16, -8, -2, -8, -16, -32, -64, -128, 0,
						0, 0, 0 },
				{ 0, 2, 6, 14, 30, 62, -2, 62, 30, 14, 6, 2, 0, 0, 0, 0 },
				{ 0, 0, 24, 60, 126, 24, 24, 24, 126, 60, 24, 0, 0, 0, 0, 0 },
				{ 0, 0, 102, 102, 102, 102, 102, 102, 102, 0, 102, 102, 0, 0,
						0, 0 },
				{ 0, 0, 127, -37, -37, -37, 123, 27, 27, 27, 27, 27, 0, 0, 0, 0 },
				{ 0, 124, -58, 96, 56, 108, -58, -58, 108, 56, 12, -58, 124, 0,
						0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 0, -2, -2, -2, -2, 0, 0, 0, 0 },
				{ 0, 0, 24, 60, 126, 24, 24, 24, 126, 60, 24, 126, 0, 0, 0, 0 },
				{ 0, 0, 24, 60, 126, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0 },
				{ 0, 0, 24, 24, 24, 24, 24, 24, 24, 126, 60, 24, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 24, 12, -2, 12, 24, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 48, 96, -2, 96, 48, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, -64, -64, -64, -2, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 40, 108, -2, 108, 40, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 16, 56, 56, 124, 124, -2, -2, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, -2, -2, 124, 124, 56, 56, 16, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 24, 60, 60, 60, 24, 24, 24, 0, 24, 24, 0, 0, 0, 0 },
				{ 0, 102, 102, 102, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 108, 108, -2, 108, 108, 108, -2, 108, 108, 0, 0, 0,
						0 },
				{ 24, 24, 124, -58, -62, -64, 124, 6, 6, -122, -58, 124, 24,
						24, 0, 0 },
				{ 0, 0, 0, 0, -62, -58, 12, 24, 48, 96, -58, -122, 0, 0, 0, 0 },
				{ 0, 0, 56, 108, 108, 56, 118, -36, -52, -52, -52, 118, 0, 0,
						0, 0 },
				{ 0, 48, 48, 48, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 12, 24, 48, 48, 48, 48, 48, 48, 24, 12, 0, 0, 0, 0 },
				{ 0, 0, 48, 24, 12, 12, 12, 12, 12, 12, 24, 48, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 102, 60, -1, 60, 102, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 24, 24, 126, 24, 24, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 24, 24, 48, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 24, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 2, 6, 12, 24, 48, 96, -64, -128, 0, 0, 0, 0 },
				{ 0, 0, 56, 108, -58, -58, -42, -42, -58, -58, 108, 56, 0, 0,
						0, 0 },
				{ 0, 0, 24, 56, 120, 24, 24, 24, 24, 24, 24, 126, 0, 0, 0, 0 },
				{ 0, 0, 124, -58, 6, 12, 24, 48, 96, -64, -58, -2, 0, 0, 0, 0 },
				{ 0, 0, 124, -58, 6, 6, 60, 6, 6, 6, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 12, 28, 60, 108, -52, -2, 12, 12, 12, 30, 0, 0, 0, 0 },
				{ 0, 0, -2, -64, -64, -64, -4, 6, 6, 6, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 56, 96, -64, -64, -4, -58, -58, -58, -58, 124, 0, 0, 0,
						0 },
				{ 0, 0, -2, -58, 6, 6, 12, 24, 48, 48, 48, 48, 0, 0, 0, 0 },
				{ 0, 0, 124, -58, -58, -58, 124, -58, -58, -58, -58, 124, 0, 0,
						0, 0 },
				{ 0, 0, 124, -58, -58, -58, 126, 6, 6, 6, 12, 120, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 24, 24, 0, 0, 0, 24, 24, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 24, 24, 0, 0, 0, 24, 24, 48, 0, 0, 0, 0 },
				{ 0, 0, 0, 6, 12, 24, 48, 96, 48, 24, 12, 6, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 126, 0, 0, 126, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 96, 48, 24, 12, 6, 12, 24, 48, 96, 0, 0, 0, 0 },
				{ 0, 0, 124, -58, -58, 12, 24, 24, 24, 0, 24, 24, 0, 0, 0, 0 },
				{ 0, 0, 0, 124, -58, -58, -34, -34, -34, -36, -64, 124, 0, 0,
						0, 0 },
				{ 0, 0, 16, 56, 108, -58, -58, -2, -58, -58, -58, -58, 0, 0, 0,
						0 },
				{ 0, 0, -4, 102, 102, 102, 124, 102, 102, 102, 102, -4, 0, 0,
						0, 0 },
				{ 0, 0, 60, 102, -62, -64, -64, -64, -64, -62, 102, 60, 0, 0,
						0, 0 },
				{ 0, 0, -8, 108, 102, 102, 102, 102, 102, 102, 108, -8, 0, 0,
						0, 0 },
				{ 0, 0, -2, 102, 98, 104, 120, 104, 96, 98, 102, -2, 0, 0, 0, 0 },
				{ 0, 0, -2, 102, 98, 104, 120, 104, 96, 96, 96, -16, 0, 0, 0, 0 },
				{ 0, 0, 60, 102, -62, -64, -64, -34, -58, -58, 102, 58, 0, 0,
						0, 0 },
				{ 0, 0, -58, -58, -58, -58, -2, -58, -58, -58, -58, -58, 0, 0,
						0, 0 },
				{ 0, 0, 60, 24, 24, 24, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 0, 30, 12, 12, 12, 12, 12, -52, -52, -52, 120, 0, 0, 0, 0 },
				{ 0, 0, -26, 102, 102, 108, 120, 120, 108, 102, 102, -26, 0, 0,
						0, 0 },
				{ 0, 0, -16, 96, 96, 96, 96, 96, 96, 98, 102, -2, 0, 0, 0, 0 },
				{ 0, 0, -58, -18, -2, -2, -42, -58, -58, -58, -58, -58, 0, 0,
						0, 0 },
				{ 0, 0, -58, -26, -10, -2, -34, -50, -58, -58, -58, -58, 0, 0,
						0, 0 },
				{ 0, 0, 124, -58, -58, -58, -58, -58, -58, -58, -58, 124, 0, 0,
						0, 0 },
				{ 0, 0, -4, 102, 102, 102, 124, 96, 96, 96, 96, -16, 0, 0, 0, 0 },
				{ 0, 0, 124, -58, -58, -58, -58, -58, -58, -42, -34, 124, 12,
						14, 0, 0 },
				{ 0, 0, -4, 102, 102, 102, 124, 108, 102, 102, 102, -26, 0, 0,
						0, 0 },
				{ 0, 0, 124, -58, -58, 96, 56, 12, 6, -58, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 126, 126, 90, 24, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 0, -58, -58, -58, -58, -58, -58, -58, -58, -58, 124, 0, 0,
						0, 0 },
				{ 0, 0, -58, -58, -58, -58, -58, -58, -58, 108, 56, 16, 0, 0,
						0, 0 },
				{ 0, 0, -58, -58, -58, -58, -42, -42, -42, -2, -18, 108, 0, 0,
						0, 0 },
				{ 0, 0, -58, -58, 108, 124, 56, 56, 124, 108, -58, -58, 0, 0,
						0, 0 },
				{ 0, 0, 102, 102, 102, 102, 60, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 0, -2, -58, -122, 12, 24, 48, 96, -62, -58, -2, 0, 0, 0, 0 },
				{ 0, 0, 60, 48, 48, 48, 48, 48, 48, 48, 48, 60, 0, 0, 0, 0 },
				{ 0, 0, 0, -128, -64, -32, 112, 56, 28, 14, 6, 2, 0, 0, 0, 0 },
				{ 0, 0, 60, 12, 12, 12, 12, 12, 12, 12, 12, 60, 0, 0, 0, 0 },
				{ 16, 56, 108, -58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0 },
				{ 48, 48, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 120, 12, 124, -52, -52, -52, 118, 0, 0, 0, 0 },
				{ 0, 0, -32, 96, 96, 120, 108, 102, 102, 102, 102, 124, 0, 0,
						0, 0 },
				{ 0, 0, 0, 0, 0, 124, -58, -64, -64, -64, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 28, 12, 12, 60, 108, -52, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 0, 0, 0, 0, 124, -58, -2, -64, -64, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 56, 108, 100, 96, -16, 96, 96, 96, 96, -16, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 118, -52, -52, -52, -52, -52, 124, 12, -52,
						120, 0 },
				{ 0, 0, -32, 96, 96, 108, 118, 102, 102, 102, 102, -26, 0, 0,
						0, 0 },
				{ 0, 0, 24, 24, 0, 56, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 0, 6, 6, 0, 14, 6, 6, 6, 6, 6, 6, 102, 102, 60, 0 },
				{ 0, 0, -32, 96, 96, 102, 108, 120, 120, 108, 102, -26, 0, 0,
						0, 0 },
				{ 0, 0, 56, 24, 24, 24, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -20, -2, -42, -42, -42, -42, -58, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -36, 102, 102, 102, 102, 102, 102, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 124, -58, -58, -58, -58, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -36, 102, 102, 102, 102, 102, 124, 96, 96,
						-16, 0 },
				{ 0, 0, 0, 0, 0, 118, -52, -52, -52, -52, -52, 124, 12, 12, 30,
						0 },
				{ 0, 0, 0, 0, 0, -36, 118, 102, 96, 96, 96, -16, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 124, -58, 96, 56, 12, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 16, 48, 48, -4, 48, 48, 48, 48, 54, 28, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -52, -52, -52, -52, -52, -52, 118, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 102, 102, 102, 102, 102, 60, 24, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -58, -58, -42, -42, -42, -2, 108, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -58, 108, 56, 56, 56, 108, -58, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -58, -58, -58, -58, -58, -58, 126, 6, 12, -8,
						0 },
				{ 0, 0, 0, 0, 0, -2, -52, 24, 48, 96, -58, -2, 0, 0, 0, 0 },
				{ 0, 0, 14, 24, 24, 24, 112, 24, 24, 24, 24, 14, 0, 0, 0, 0 },
				{ 0, 0, 24, 24, 24, 24, 0, 24, 24, 24, 24, 24, 0, 0, 0, 0 },
				{ 0, 0, 112, 24, 24, 24, 14, 24, 24, 24, 24, 112, 0, 0, 0, 0 },
				{ 0, 0, 118, -36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 16, 56, 108, -58, -58, -58, -2, 0, 0, 0, 0, 0 },
				{ 0, 0, 60, 102, -62, -64, -64, -64, -62, 102, 60, 12, 6, 124,
						0, 0 },
				{ 0, 0, -52, 0, 0, -52, -52, -52, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 12, 24, 48, 0, 124, -58, -2, -64, -64, -58, 124, 0, 0, 0,
						0 },
				{ 0, 16, 56, 108, 0, 120, 12, 124, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 0, -52, 0, 0, 120, 12, 124, -52, -52, -52, 118, 0, 0, 0, 0 },
				{ 0, 96, 48, 24, 0, 120, 12, 124, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 56, 108, 56, 0, 120, 12, 124, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 0, 0, 0, 60, 102, 96, 96, 102, 60, 12, 6, 60, 0, 0, 0 },
				{ 0, 16, 56, 108, 0, 124, -58, -2, -64, -64, -58, 124, 0, 0, 0,
						0 },
				{ 0, 0, -58, 0, 0, 124, -58, -2, -64, -64, -58, 124, 0, 0, 0, 0 },
				{ 0, 96, 48, 24, 0, 124, -58, -2, -64, -64, -58, 124, 0, 0, 0,
						0 },
				{ 0, 0, 102, 0, 0, 56, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 24, 60, 102, 0, 56, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 96, 48, 24, 0, 56, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, -58, 0, 16, 56, 108, -58, -58, -2, -58, -58, -58, 0, 0, 0,
						0 },
				{ 56, 108, 56, 0, 56, 108, -58, -58, -2, -58, -58, -58, 0, 0,
						0, 0 },
				{ 24, 48, 96, 0, -2, 102, 96, 124, 96, 96, 102, -2, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -52, 118, 54, 126, -40, -40, 110, 0, 0, 0, 0 },
				{ 0, 0, 62, 108, -52, -52, -2, -52, -52, -52, -52, -50, 0, 0,
						0, 0 },
				{ 0, 16, 56, 108, 0, 124, -58, -58, -58, -58, -58, 124, 0, 0,
						0, 0 },
				{ 0, 0, -58, 0, 0, 124, -58, -58, -58, -58, -58, 124, 0, 0, 0,
						0 },
				{ 0, 96, 48, 24, 0, 124, -58, -58, -58, -58, -58, 124, 0, 0, 0,
						0 },
				{ 0, 48, 120, -52, 0, -52, -52, -52, -52, -52, -52, 118, 0, 0,
						0, 0 },
				{ 0, 96, 48, 24, 0, -52, -52, -52, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 0, -58, 0, 0, -58, -58, -58, -58, -58, -58, 126, 6, 12,
						120, 0 },
				{ 0, -58, 0, 124, -58, -58, -58, -58, -58, -58, -58, 124, 0, 0,
						0, 0 },
				{ 0, -58, 0, -58, -58, -58, -58, -58, -58, -58, -58, 124, 0, 0,
						0, 0 },
				{ 0, 24, 24, 60, 102, 96, 96, 96, 102, 60, 24, 24, 0, 0, 0, 0 },
				{ 0, 56, 108, 100, 96, -16, 96, 96, 96, 96, -26, -4, 0, 0, 0, 0 },
				{ 0, 0, 102, 102, 60, 24, 126, 24, 126, 24, 24, 24, 0, 0, 0, 0 },
				{ 0, -8, -52, -52, -8, -60, -52, -34, -52, -52, -52, -58, 0, 0,
						0, 0 },
				{ 0, 14, 27, 24, 24, 24, 126, 24, 24, 24, 24, 24, -40, 112, 0,
						0 },
				{ 0, 24, 48, 96, 0, 120, 12, 124, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 12, 24, 48, 0, 56, 24, 24, 24, 24, 24, 60, 0, 0, 0, 0 },
				{ 0, 24, 48, 96, 0, 124, -58, -58, -58, -58, -58, 124, 0, 0, 0,
						0 },
				{ 0, 24, 48, 96, 0, -52, -52, -52, -52, -52, -52, 118, 0, 0, 0,
						0 },
				{ 0, 0, 118, -36, 0, -36, 102, 102, 102, 102, 102, 102, 0, 0,
						0, 0 },
				{ 118, -36, 0, -58, -26, -10, -2, -34, -50, -58, -58, -58, 0,
						0, 0, 0 },
				{ 0, 60, 108, 108, 62, 0, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 56, 108, 108, 56, 0, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 48, 48, 0, 48, 48, 96, -64, -58, -58, 124, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, -2, -64, -64, -64, -64, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, -2, 6, 6, 6, 6, 0, 0, 0, 0, 0 },
				{ 0, -64, -64, -62, -58, -52, 24, 48, 96, -36, -122, 12, 24,
						62, 0, 0 },
				{ 0, -64, -64, -62, -58, -52, 24, 48, 102, -50, -98, 62, 6, 6,
						0, 0 },
				{ 0, 0, 24, 24, 0, 24, 24, 24, 60, 60, 60, 24, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 54, 108, -40, 108, 54, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -40, 108, 54, 108, -40, 0, 0, 0, 0, 0, 0 },
				{ 17, 68, 17, 68, 17, 68, 17, 68, 17, 68, 17, 68, 17, 68, 17,
						68 },
				{ 85, -86, 85, -86, 85, -86, 85, -86, 85, -86, 85, -86, 85,
						-86, 85, -86 },
				{ -35, 119, -35, 119, -35, 119, -35, 119, -35, 119, -35, 119,
						-35, 119, -35, 119 },
				{ 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
						24 },
				{ 24, 24, 24, 24, 24, 24, 24, -8, 24, 24, 24, 24, 24, 24, 24,
						24 },
				{ 24, 24, 24, 24, 24, -8, 24, -8, 24, 24, 24, 24, 24, 24, 24,
						24 },
				{ 54, 54, 54, 54, 54, 54, 54, -10, 54, 54, 54, 54, 54, 54, 54,
						54 },
				{ 0, 0, 0, 0, 0, 0, 0, -2, 54, 54, 54, 54, 54, 54, 54, 54 },
				{ 0, 0, 0, 0, 0, -8, 24, -8, 24, 24, 24, 24, 24, 24, 24, 24 },
				{ 54, 54, 54, 54, 54, -10, 6, -10, 54, 54, 54, 54, 54, 54, 54,
						54 },
				{ 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
						54 },
				{ 0, 0, 0, 0, 0, -2, 6, -10, 54, 54, 54, 54, 54, 54, 54, 54 },
				{ 54, 54, 54, 54, 54, -10, 6, -2, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 54, 54, 54, 54, 54, 54, 54, -2, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 24, 24, 24, 24, 24, -8, 24, -8, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, -8, 24, 24, 24, 24, 24, 24, 24, 24 },
				{ 24, 24, 24, 24, 24, 24, 24, 31, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 24, 24, 24, 24, 24, 24, 24, -1, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, -1, 24, 24, 24, 24, 24, 24, 24, 24 },
				{ 24, 24, 24, 24, 24, 24, 24, 31, 24, 24, 24, 24, 24, 24, 24,
						24 },
				{ 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 24, 24, 24, 24, 24, 24, 24, -1, 24, 24, 24, 24, 24, 24, 24,
						24 },
				{ 24, 24, 24, 24, 24, 31, 24, 31, 24, 24, 24, 24, 24, 24, 24,
						24 },
				{ 54, 54, 54, 54, 54, 54, 54, 55, 54, 54, 54, 54, 54, 54, 54,
						54 },
				{ 54, 54, 54, 54, 54, 55, 48, 63, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 63, 48, 55, 54, 54, 54, 54, 54, 54, 54, 54 },
				{ 54, 54, 54, 54, 54, -9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -1, 0, -9, 54, 54, 54, 54, 54, 54, 54, 54 },
				{ 54, 54, 54, 54, 54, 55, 48, 55, 54, 54, 54, 54, 54, 54, 54,
						54 },
				{ 0, 0, 0, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 54, 54, 54, 54, 54, -9, 0, -9, 54, 54, 54, 54, 54, 54, 54, 54 },
				{ 24, 24, 24, 24, 24, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 54, 54, 54, 54, 54, 54, 54, -1, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, -1, 0, -1, 24, 24, 24, 24, 24, 24, 24, 24 },
				{ 0, 0, 0, 0, 0, 0, 0, -1, 54, 54, 54, 54, 54, 54, 54, 54 },
				{ 54, 54, 54, 54, 54, 54, 54, 63, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 24, 24, 24, 24, 24, 31, 24, 31, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 31, 24, 31, 24, 24, 24, 24, 24, 24, 24, 24 },
				{ 0, 0, 0, 0, 0, 0, 0, 63, 54, 54, 54, 54, 54, 54, 54, 54 },
				{ 54, 54, 54, 54, 54, 54, 54, -1, 54, 54, 54, 54, 54, 54, 54,
						54 },
				{ 24, 24, 24, 24, 24, -1, 24, -1, 24, 24, 24, 24, 24, 24, 24,
						24 },
				{ 24, 24, 24, 24, 24, 24, 24, -8, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 31, 24, 24, 24, 24, 24, 24, 24, 24 },
				{ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
						-1 },
				{ 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
				{ -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16,
						-16, -16, -16, -16 },
				{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
						15 },
				{ -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 118, -36, -40, -40, -40, -36, 118, 0, 0, 0, 0 },
				{ 0, 0, 120, -52, -52, -52, -40, -52, -58, -58, -58, -52, 0, 0,
						0, 0 },
				{ 0, 0, -2, -58, -58, -64, -64, -64, -64, -64, -64, -64, 0, 0,
						0, 0 },
				{ 0, 0, 0, 0, -2, 108, 108, 108, 108, 108, 108, 108, 0, 0, 0, 0 },
				{ 0, 0, 0, -2, -58, 96, 48, 24, 48, 96, -58, -2, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 126, -40, -40, -40, -40, -40, 112, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 102, 102, 102, 102, 102, 124, 96, 96, -64, 0, 0,
						0 },
				{ 0, 0, 0, 0, 118, -36, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0 },
				{ 0, 0, 0, 126, 24, 60, 102, 102, 102, 60, 24, 126, 0, 0, 0, 0 },
				{ 0, 0, 0, 56, 108, -58, -58, -2, -58, -58, 108, 56, 0, 0, 0, 0 },
				{ 0, 0, 56, 108, -58, -58, -58, 108, 108, 108, 108, -18, 0, 0,
						0, 0 },
				{ 0, 0, 30, 48, 24, 12, 62, 102, 102, 102, 102, 60, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 126, -37, -37, -37, 126, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 3, 6, 126, -37, -37, -13, 126, 96, -64, 0, 0, 0, 0 },
				{ 0, 0, 28, 48, 96, 96, 124, 96, 96, 96, 48, 28, 0, 0, 0, 0 },
				{ 0, 0, 0, 124, -58, -58, -58, -58, -58, -58, -58, -58, 0, 0,
						0, 0 },
				{ 0, 0, 0, 0, -2, 0, 0, -2, 0, 0, -2, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 24, 24, 126, 24, 24, 0, 0, -1, 0, 0, 0, 0 },
				{ 0, 0, 0, 48, 24, 12, 6, 12, 24, 48, 0, 126, 0, 0, 0, 0 },
				{ 0, 0, 0, 12, 24, 48, 96, 48, 24, 12, 0, 126, 0, 0, 0, 0 },
				{ 0, 0, 14, 27, 27, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24 },
				{ 24, 24, 24, 24, 24, 24, 24, 24, -40, -40, -40, 112, 0, 0, 0,
						0 },
				{ 0, 0, 0, 0, 24, 24, 0, 126, 0, 24, 24, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 118, -36, 0, 118, -36, 0, 0, 0, 0, 0, 0 },
				{ 0, 56, 108, 108, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 24, 24, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 15, 12, 12, 12, 12, 12, -20, 108, 108, 60, 28, 0, 0, 0, 0 },
				{ 0, -40, 108, 108, 108, 108, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 112, -40, 48, 96, -56, -8, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 124, 124, 124, 124, 124, 124, 124, 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } };
	}
}
