import java.util.zip.*;
import java.io.FileInputStream;
import java.io.*;
import java.net.*;

public class Decoder {
	private DataInputStream inputStream;

	private ScreenBuffer[] buffers;

	private class ChunkHeader {
		public short pos, len;

		ChunkHeader(short p, short l) {
			pos = p;
			len = l;
		}
	}

	public final static short changeShortEndian(short v) {
		return (short) (((v & 0xff) << 8) | ((v & 0xff00) >> 8));
	}

	public final static int changeIntEndian(int v) {
		// return (v>>>24)|(v<<24)|((v<<8) & 0xff0000)|((v<<16) & 0xff00);false
		// aproape
		return ((v & 0xff) << 24) | ((v & 0xff00) << 8) | ((v & 0xff0000) >> 8)
				| ((v & 0xff000000) >>> 24);
	}

	public void close() {
		if (inputStream != null) {
			try {
				inputStream.close();
			} catch (IOException e) {
			}
		}
	}

	public Decoder(String filePath, int inputMode)
	// t==0 - local file;
	// t==1 - URL
	{
		try {
			if (inputMode == 0) {
				FileInputStream fi = new FileInputStream(filePath);
				inputStream = new DataInputStream(new GZIPInputStream(fi));
			}
			if (inputMode == 1) {
				URL url = new URL(filePath);
				URLConnection conn = null;
				conn = url.openConnection();
				conn.connect();

				inputStream = new DataInputStream(new GZIPInputStream(
						new BufferedInputStream(conn.getInputStream(), 4096)));
			}
		} catch (IOException e) {
			System.out.println("Can't open file stream");
			inputStream = null;
			return;
		}

		System.out.println("MarkSupported:" + inputStream.markSupported());
		inputStream.mark(2 * 1000 * 1000 * 1000);

		// initialize screen buffers
		buffers = new ScreenBuffer[256];
		for (int i = 0; i < 256; i++)
			buffers[i] = new ScreenBuffer(80, 50, 32, 7);
	}

	private ChunkHeader[] chunkHeaders = new ChunkHeader[4000];

	private ScreenBuffer[] chunks = new ScreenBuffer[4000];

	public Frame nextFrame() {
		int delay;
		byte cx;
		byte cy;
		int srcbuf;
		int destbuf;
		short chunkNr;
		if (inputStream == null)
			return null;
		try {
			delay = changeIntEndian(inputStream.readInt());
			cx = inputStream.readByte();
			cy = inputStream.readByte();
			srcbuf = inputStream.readByte();
			destbuf = inputStream.readByte();
			chunkNr = changeShortEndian(inputStream.readShort());
			for (int i = 0; i < chunkNr; i++)
				chunkHeaders[i] = new ChunkHeader(changeShortEndian(inputStream
						.readShort()), changeShortEndian(inputStream
						.readShort()));
			for (int i = 0; i < chunkNr; i++) {
				chunks[i] = new ScreenBuffer(4000, 1);
				for (int j = 0; j < chunkHeaders[i].len; j++) {
					chunks[i].buffer[j][0] = inputStream.readByte();// char
					chunks[i].buffer[j][1] = inputStream.readByte();// attr
				}
			}
		} catch (IOException e) {
			try {
				inputStream.close();
			} catch (IOException e2) {
			}
			inputStream = null;
			return null;
		}
		if (srcbuf < 0)
			srcbuf += 256;
		if (destbuf < 0)
			destbuf += 256;
		buffers[destbuf].copyFrom(buffers[srcbuf], 0, 0, 80 * 50);
		for (int i = 0; i < chunkNr; i++)
			buffers[destbuf].copyFrom(chunks[i], 0, chunkHeaders[i].pos,
					chunkHeaders[i].len);
		return new Frame(buffers[destbuf], cx, cy, delay + 3500 - 3500);
	}
}
