import java.awt.*;

public class MainThread implements Runnable 
{
	public Decoder decoder;
	public Frame frame, frameOnScreen, skippedFrame;
	private long startTime, demoTime;
	//private long lateTime;
	private Show mainClass;
	
	public MainThread(Show comp)
	{
		mainClass = comp; 
	}
	
	public void run() 
	{
		decoder = new Decoder(mainClass.demoAddress, mainClass.mediaType);
		Graphics graphics = mainClass.getGraphics();
		startTime = System.currentTimeMillis();
		demoTime = 0;
		//lateTime = 0;
		frameOnScreen = frame = decoder.nextFrame();
		skippedFrame=null;
		mainClass.paint(graphics, true);  // force initial paint
		while(frame!=null)
		{
			demoTime += frame.delay;
			long toSleep = demoTime - (System.currentTimeMillis()-startTime);
			if(toSleep<0)
			{
			  	//lateTime -= toSleep;
				//System.out.println("Latency: "+(lateTime*100/demoTime)+"%");
				toSleep=0; // this disables frame skip
			}
			if(toSleep>=0)
			{
				if(skippedFrame!=null)
				{
					frameOnScreen = skippedFrame;
					mainClass.paint(graphics, false);
				}
				try
				{
					//Thread.sleep(frame.delay);
					if(toSleep>0)
						Thread.sleep(toSleep);
				}
				catch(InterruptedException e)
				{
					return;
				}
				// TODO: show note
				frameOnScreen = frame;
				mainClass.paint(graphics, false);
				skippedFrame = null;
			}
			else
			{
				skippedFrame = frame;
			  	System.out.println("Skipping frame - late by "+(-toSleep)+" ms");
			}
			
			synchronized(frame)
			{
				frame = decoder.nextFrame();
			}
		}
	}
}
