import java.awt.*;

public class Renderer 
{
    private ScreenBuffer screen = new ScreenBuffer(80, 50, 0xFF, 0xFF);
    private Image imageBuffer;
    private Graphics imageBufferGraphics;
    private int cursorX=0, cursorY=0;
    private Component component;
    private Boolean drawcursor;
    
    public Renderer(Component comp, Boolean drawcursor)
    {
    	component = comp;
    	this.drawcursor = drawcursor;
    }
    
    public void RenderFrame(Frame frame, Graphics graphics, boolean force)
    {
    	if(imageBuffer==null)
    	{
    		imageBuffer = component.createImage(80*8,50*16);
    		imageBufferGraphics = imageBuffer.getGraphics();
    	}

    	// invalidate the old and new cursor coords
    	screen.buffer[cursorY*80+cursorX][0]=(byte)0xFF; 
    	screen.buffer[cursorY*80+cursorX][1]=(byte)0xFF; 
    	screen.buffer[frame.cursorY*80+frame.cursorX][0]=(byte)0xFF; 
    	screen.buffer[frame.cursorY*80+frame.cursorX][1]=(byte)0xFF; 

    	byte[] character;
    	for(int i=0;i<80;i++)
        	for(int j=0;j<50;j++)
        	{
        		character = frame.screen.buffer[j*80+i];
        		if(force || character[0]!=screen.buffer[j*80+i][0] || character[1]!=screen.buffer[j*80+i][1])
        		{
        			imageBufferGraphics.drawImage(CharCache.getCharImage(component, character[0], character[1]), i*8, j*16, null);
        			//DOSFont.drawbmAttrAccShort(imageBufferGraphics, character[0], (byte)character[1], i*8, j*16);
        			screen.buffer[j*80+i][0] = character[0]; 
        			screen.buffer[j*80+i][1] = character[1]; 
        		}
        	}
        if(drawcursor==true)
        {
	        cursorX = frame.cursorX;
	        cursorY = frame.cursorY;
	    	DOSFont.drawCursor(imageBufferGraphics, screen.buffer[cursorY*80+cursorX][1], cursorX*8, cursorY*16);
		}
    	graphics.drawImage(imageBuffer, 0, 0, null);
    }
}
