import java.applet.*;
import java.awt.*;
import java.awt.event.KeyEvent;

public class Show extends Applet {
	/**
	 * Main applet
	 */
	private static final long serialVersionUID = 1L;

	public int mediaType;
	public String demoAddress;
	private Thread mainThreadThread;
	private MainThread mainThread;
	private Renderer renderer;
	private Boolean drawcursor;

	public void init() {
		Dimension dim = new Dimension(80 * 8, 50 * 16);
		this.setMinimumSize(dim);
		this.setMaximumSize(dim);
		this.setSize(dim);

		String pType = getParameter("type");
		demoAddress = getParameter("address");
		drawcursor = new Boolean(getParameter("drawcursor"));
		if(pType==null || demoAddress==null)
		{
			mediaType = 0;
			demoAddress = "C:\\Documents and Settings\\Vladimir\\My Documents\\Borland Studio Projects\\DosRecorder\\Java\\Source\\crl12-pre.dm2"; 
			//demoAddress = "C:\\Documents and Settings\\Vladimir\\My Documents\\Borland Studio Projects\\DosRecorder\\Tests\\DelayOrder\\delayorder.dm2";
		} 
		else
		{
			mediaType = 0;
			if (pType.compareTo("remote") == 0)
				mediaType = 1;
			if (pType.compareTo("local") == 0)
				mediaType = 0;
		}
		
		renderer = new Renderer(this,drawcursor);
		mainThread = new MainThread(this);
		mainThreadThread = new Thread(mainThread);
		mainThreadThread.start();
	}

	protected void processKeyEvent(KeyEvent e) 
	{
		// TODO Auto-generated method stub
		super.processKeyEvent(e);
	}

	public void paint(Graphics g) 
	{
		paint(g, true);
	}

	public void paint(Graphics g, boolean force) 
	{
		if(mainThread.frameOnScreen!=null)
			synchronized(mainThread.frameOnScreen)
			{
				renderer.RenderFrame(mainThread.frameOnScreen, g, force);
			}
	}
	 
    public void destroy() 
    { 
    	mainThread.decoder.close();
    	mainThreadThread = null;
		mainThread = null;
		renderer = null;
    }
}